/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ChapterImageButton
extends Button {
    public QuestScreen questScreen;
    public ChapterImage chapterImage;

    public ChapterImageButton(Panel panel, ChapterImage i) {
        super(panel, StringTextComponent.field_240750_d_, i.image);
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && (!this.chapterImage.click.isEmpty() || this.questScreen.file.canEdit() && !button.isLeft())) {
            this.onClicked(button);
            return true;
        }
        return false;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.questPanel.mouseOverQuest != null || this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        if (this.chapterImage.click.isEmpty() && !this.questScreen.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void onClicked(MouseButton button) {
        if (this.questScreen.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                ConfigGroup group = new ConfigGroup("ftbquests");
                this.chapterImage.getConfig(group.getGroup("chapter").getGroup("image"));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        new EditObjectMessage(this.chapterImage.chapter).sendToServer();
                    }
                    this.run();
                };
                new EditConfigScreen(group).openGui();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.chapter), () -> {
                this.questScreen.movingObjects = true;
                this.questScreen.selectedObjects.clear();
                this.questScreen.toggleSelected(this.chapterImage);
            }){

                public void addMouseOverText(TooltipList list) {
                    list.add((ITextComponent)new TranslationTextComponent("ftbquests.gui.move_tooltip").func_240699_a_(TextFormatting.DARK_GRAY));
                }
            });
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.chapter.images.remove(this.chapterImage);
                new EditObjectMessage(this.chapterImage.chapter).sendToServer();
            }).setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{this.chapterImage.image.toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (!this.chapterImage.click.isEmpty()) {
                this.playClickSound();
                this.handleClick(this.chapterImage.click);
            }
        } else if (this.questScreen.file.canEdit() && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.chapterImage)) {
                this.questScreen.toggleSelected(this.chapterImage);
            }
            this.questScreen.movingObjects = true;
        }
    }

    public void addMouseOverText(TooltipList list) {
        for (String s : this.chapterImage.hover) {
            if (s.startsWith("{") && s.endsWith("}")) {
                list.add((ITextComponent)new TranslationTextComponent(s.substring(1, s.length() - 1)));
                continue;
            }
            list.add((ITextComponent)new StringTextComponent(s));
        }
    }

    public boolean shouldDraw() {
        return false;
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        boolean transparent = this.chapterImage.dependency != null && !this.questScreen.file.self.isCompleted(this.chapterImage.dependency);
        GuiHelper.setupDrawing();
        matrixStack.func_227860_a_();
        if (this.chapterImage.corner) {
            matrixStack.func_227861_a_((double)x, (double)y, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.chapterImage.rotation));
            matrixStack.func_227862_a_((float)w, (float)h, 1.0f);
            (transparent ? this.chapterImage.image.withColor(Color4I.WHITE.withAlpha(100)) : this.chapterImage.image).draw(matrixStack, 0, 0, 1, 1);
        } else {
            matrixStack.func_227861_a_((double)((int)((double)x + (double)w / 2.0)), (double)((int)((double)y + (double)h / 2.0)), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.chapterImage.rotation));
            matrixStack.func_227862_a_((float)w / 2.0f, (float)h / 2.0f, 1.0f);
            (transparent ? this.chapterImage.image.withColor(Color4I.WHITE.withAlpha(100)) : this.chapterImage.image).draw(matrixStack, -1, -1, 2, 2);
        }
        matrixStack.func_227865_b_();
    }
}

